#NoEnv
#SingleInstance Force
#Persistent
SetTitleMatchMode, 2
CoordMode, Mouse, Screen

; ============================================================
; TRAY MENU
; ============================================================

Menu, Tray, NoStandard
Menu, Tray, Tip, Window Tools (Ctrl+RightClick / Ctrl+Win+T)
Menu, Tray, Add, Help, TrayHelp
Menu, Tray, Add
Menu, Tray, Add, Toggle Always On Top (active), TrayToggleTop
Menu, Tray, Add
Menu, Tray, Add, Exit, TrayExit


; ============================================================
; CONTEXT MENU + SUBMENUS
; ============================================================

Menu, WinTopMenu, Add, Always On Top, ToggleTop

; --- Transparency submenu ---
Menu, TransparencyMenu, Add, 10`% opacity,  Trans10
Menu, TransparencyMenu, Add, 50`% opacity,  Trans50
Menu, TransparencyMenu, Add, 80`% opacity,  Trans80
Menu, TransparencyMenu, Add, 100`% (reset), Trans100

; --- Size submenu ---
Menu, SizeMenu, Add, 480p (16:9),  Size480
Menu, SizeMenu, Add, 720p (16:9),  Size720
Menu, SizeMenu, Add, 1280p (16:9), Size1280

; --- Placement submenu ---
Menu, PlaceMenu, Add, Top-Left,     PlaceTL
Menu, PlaceMenu, Add, Top-Right,    PlaceTR
Menu, PlaceMenu, Add, Bottom-Left,  PlaceBL
Menu, PlaceMenu, Add, Bottom-Right, PlaceBR

Menu, WinTopMenu, Add
Menu, WinTopMenu, Add, Transparency, :TransparencyMenu
Menu, WinTopMenu, Add, Window size,  :SizeMenu
Menu, WinTopMenu, Add, Placement,    :PlaceMenu

; ============================================================
; HOTKEYS
; ============================================================

; Ctrl + Right Click -> Show menu for window under cursor
^RButton::
    MouseGetPos, mx, my, winID
    if (!winID)
        return

    TargetWin := winID

    ; Reflect Always-On-Top state
    WinGet, ExStyle, ExStyle, ahk_id %winID%
    if (ExStyle & 0x8)
        Menu, WinTopMenu, Check, Always On Top
    else
        Menu, WinTopMenu, Uncheck, Always On Top

    Menu, WinTopMenu, Show
return


; Ctrl + Win + T -> Toggle Always-On-Top for active window
^#t::
    WinGet, activeWin, ID, A
    if (activeWin)
        ToggleTopFor(activeWin)
return


; ============================================================
; MENU HANDLERS
; ============================================================

ToggleTop:
    if (TargetWin)
        ToggleTopFor(TargetWin)
return


; --- Transparency ---
Trans10:
    SetOpacity(TargetWin, 10)
return

Trans50:
    SetOpacity(TargetWin, 50)
return

Trans80:
    SetOpacity(TargetWin, 80)
return

Trans100:
    SetOpacity(TargetWin, 100)
return


; --- Sizes ---
Size480:
    SetSizeP(TargetWin, 480)
return

Size720:
    SetSizeP(TargetWin, 720)
return

Size1280:
    SetSizeP(TargetWin, 1280)
return


; --- Placement ---
PlaceTL:
    PlaceCorner(TargetWin, "TL")
return

PlaceTR:
    PlaceCorner(TargetWin, "TR")
return

PlaceBL:
    PlaceCorner(TargetWin, "BL")
return

PlaceBR:
    PlaceCorner(TargetWin, "BR")
return


; --- Tray ---
TrayToggleTop:
    WinGet, activeWin, ID, A
    if (activeWin)
        ToggleTopFor(activeWin)
return

TrayExit:
    ExitApp
return

; --- Tray help ---
TrayHelp:
    MsgBox, 64, Window Tools - Help,
    (LTrim
    Usage:

    • Ctrl + Right-Click  → open menu for window under mouse
    • Ctrl + Win + T      → toggle Always-On-Top for active window
    )
return



; ============================================================
; HELPER FUNCTIONS
; ============================================================

ToggleTopFor(winID) {
    WinGet, ExStyle, ExStyle, ahk_id %winID%
    if (ExStyle & 0x8)
        WinSet, AlwaysOnTop, Off, ahk_id %winID%
    else
        WinSet, AlwaysOnTop, On,  ahk_id %winID%
}

SetOpacity(winID, pct) {
    if (!winID)
        return

    if (pct < 1)
        pct := 1
    if (pct > 100)
        pct := 100

    alpha := Round(255 * (pct / 100.0))
    WinSet, Transparent, %alpha%, ahk_id %winID%
}

SetSizeP(winID, height) {
    if (!winID)
        return

    width := Round(height * 16 / 9)

    WinGetPos, x, y, w, h, ahk_id %winID%
    WinMove, ahk_id %winID%, , %x%, %y%, %width%, %height%
}

PlaceCorner(winID, corner) {
    if (!winID)
        return

    WinGetPos, wx, wy, ww, wh, ahk_id %winID%
    cx := wx + (ww // 2)
    cy := wy + (wh // 2)

    SysGet, monCount, MonitorCount
    targetMon := 1

    Loop, %monCount%
    {
        SysGet, wa, MonitorWorkArea, %A_Index%
        if (cx >= waLeft && cx <= waRight && cy >= waTop && cy <= waBottom)
        {
            targetMon := A_Index
            break
        }
    }

    SysGet, wa, MonitorWorkArea, %targetMon%

    margin := 10

    if (corner = "TL") {
        nx := waLeft + margin
        ny := waTop  + margin
    } else if (corner = "TR") {
        nx := waRight - ww - margin
        ny := waTop   + margin
    } else if (corner = "BL") {
        nx := waLeft + margin
        ny := waBottom - wh - margin
    } else {
        nx := waRight - ww - margin
        ny := waBottom - wh - margin
    }

    WinMove, ahk_id %winID%, , %nx%, %ny%
}
